//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "OptionSetting_Form.h"
#include "Message_Form.h"
#include <FileCtrl.hpp>
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "TntButtons"
#pragma link "TntStdCtrls"
#pragma resource "*.dfm"
TOptionSettingForm *OptionSettingForm;
//---------------------------------------------------------------------------
__fastcall TOptionSettingForm::TOptionSettingForm(TComponent* Owner)
  : TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TOptionSettingForm::FormActivate(TObject *Sender)
{
  if(bDefault)
  {
    tempApplicationStartOption.SelectedLCID = SYSTEM_INFO_LCID_KR;
    tempApplicationStartOption.SelectedCommType = SYSTEM_INFO_COMM_TYPE_TCP_IP;
    tempApplicationStartOption.MachineType = SYSTEM_INFO_MACHINE_TYPE_200H;
    tempApplicationStartOption.comm_brdCount = SYSTEM_INFO_DEFAULT_BRD_COUNT;
    tempApplicationStartOption.LaserComplexer = 0;
    tempApplicationStartOption.sLaserPath = "";
    tempApplicationStartOption.CommCheckSW = 1;
    tempApplicationStartOption.noLicenseApplication = 0;
    tempApplicationStartOption.tmsAppName = "TVM_Application";
    tempApplicationStartOption.cmsAppName = "CVM_Application";
    tempApplicationStartOption.TPB_OperationMode = 0;
  }
  else
  {
    tempApplicationStartOption.SelectedLCID = ApplicationStartOption.SelectedLCID;
    tempApplicationStartOption.SelectedCommType = ApplicationStartOption.SelectedCommType;
    tempApplicationStartOption.MachineType = ApplicationStartOption.MachineType;
    tempApplicationStartOption.comm_brdCount = ApplicationStartOption.comm_brdCount;
    tempApplicationStartOption.LaserComplexer = ApplicationStartOption.LaserComplexer;
    tempApplicationStartOption.sLaserPath = ApplicationStartOption.sLaserPath;
    tempApplicationStartOption.CommCheckSW = ApplicationStartOption.CommCheckSW;
    tempApplicationStartOption.noLicenseApplication = ApplicationStartOption.noLicenseApplication;
    tempApplicationStartOption.tmsAppName = ApplicationStartOption.tmsAppName;
    tempApplicationStartOption.cmsAppName = ApplicationStartOption.cmsAppName;
    tempApplicationStartOption.TPB_OperationMode = ApplicationStartOption.TPB_OperationMode;
  }

  RefreshOptionComponents();

  if(LaserComplexerCheckBox->Visible)
  {
  /*
    GroupBox2->Height = 205;
    GroupBox3->Top = 552;
    Button5->Top = 730;
    Button6->Top = 730;
    this->Height = 889;
    */

    GroupBox2->Height = 249;//169;
    GroupBox3->Top = 600;
    Button5->Top = 778;
    Button6->Top = 778;
    this->Height = 960;
  }
  else
  {
  /*
    GroupBox2->Height = 140;
    GroupBox3->Top = 480;
    Button5->Top = 658;
    Button6->Top = 658;
    this->Height = 816;
    */

    GroupBox2->Height = 169;//249;
    GroupBox3->Top = 520;
    Button5->Top = 706;
    Button6->Top = 706;
    this->Height = 880;
  }
}
//---------------------------------------------------------------------------

void __fastcall TOptionSettingForm::RefreshOptionComponents()
{
  RefreshLCID();
  RefreshCommMode();
  RefreshMachineType();
  RefreshBoardCount();
  RefreshLaserMode();
  RefreshCommCheckSW();
  RefreshLicenseCheckSW();
  RefreshAppsTitle();
  RefreshTPBOperationMode();
}

//---------------------------------------------------------------------------
void __fastcall TOptionSettingForm::RefreshLCID()
{
  //Default LCID State
  if(tempApplicationStartOption.SelectedLCID == 1042)
  {
    Image2->Picture->Bitmap->Assign(Image5->Picture->Bitmap);
    Image3->Picture->Bitmap->Assign(Image9->Picture->Bitmap);
    Image4->Picture->Bitmap->Assign(Image10->Picture->Bitmap);
    Image11->Picture->Bitmap->Assign(Image15->Picture->Bitmap);
    Image1->Picture->Bitmap->Assign(Image12->Picture->Bitmap);
  }
  else if(tempApplicationStartOption.SelectedLCID == 2052)
  {
    Image2->Picture->Bitmap->Assign(Image8->Picture->Bitmap);
    Image3->Picture->Bitmap->Assign(Image6->Picture->Bitmap);
    Image4->Picture->Bitmap->Assign(Image10->Picture->Bitmap);
    Image11->Picture->Bitmap->Assign(Image15->Picture->Bitmap);
    Image1->Picture->Bitmap->Assign(Image12->Picture->Bitmap);
  }
  else if(tempApplicationStartOption.SelectedLCID == 1033)
  {
    Image2->Picture->Bitmap->Assign(Image8->Picture->Bitmap);
    Image3->Picture->Bitmap->Assign(Image9->Picture->Bitmap);
    Image4->Picture->Bitmap->Assign(Image7->Picture->Bitmap);
    Image11->Picture->Bitmap->Assign(Image15->Picture->Bitmap);
    Image1->Picture->Bitmap->Assign(Image12->Picture->Bitmap);
  }
  else if(tempApplicationStartOption.SelectedLCID == 1041)
  {
    Image2->Picture->Bitmap->Assign(Image8->Picture->Bitmap);
    Image3->Picture->Bitmap->Assign(Image9->Picture->Bitmap);
    Image4->Picture->Bitmap->Assign(Image10->Picture->Bitmap);
    Image11->Picture->Bitmap->Assign(Image14->Picture->Bitmap);
    Image1->Picture->Bitmap->Assign(Image12->Picture->Bitmap);
  }
  else if(tempApplicationStartOption.SelectedLCID == 1034||tempApplicationStartOption.SelectedLCID == 3082)
  {
    Image2->Picture->Bitmap->Assign(Image8->Picture->Bitmap);
    Image3->Picture->Bitmap->Assign(Image9->Picture->Bitmap);
    Image4->Picture->Bitmap->Assign(Image10->Picture->Bitmap);
    Image11->Picture->Bitmap->Assign(Image15->Picture->Bitmap);
    Image1->Picture->Bitmap->Assign(Image13->Picture->Bitmap);
  }
  else
  {
    Image2->Picture->Bitmap->Assign(Image5->Picture->Bitmap);
    Image3->Picture->Bitmap->Assign(Image9->Picture->Bitmap);
    Image4->Picture->Bitmap->Assign(Image10->Picture->Bitmap);
    Image11->Picture->Bitmap->Assign(Image15->Picture->Bitmap);
    Image1->Picture->Bitmap->Assign(Image12->Picture->Bitmap);
  }
}

//---------------------------------------------------------------------------
void __fastcall TOptionSettingForm::RefreshCommMode()
{
  int commID;
  for(commID = 1; commID <= 3; commID++)
  {
    TTntSpeedButton *ActiveModeBtn = (TTntSpeedButton *)FindComponent("ActiveModeBtn" + IntToStr(commID));
    if(ActiveModeBtn)
    {
      ActiveModeBtn->Font->Color = clBlack;

      if(commID == tempApplicationStartOption.SelectedCommType)
      {
        ActiveModeBtn->Font->Color = clRed;
        ActiveModeBtn->Down = true;
      }
    }
  }
}

//---------------------------------------------------------------------------
void __fastcall TOptionSettingForm::RefreshMachineType()
{
  int machineID;

  for(machineID = 0; machineID < 4; machineID++)
  {
    TTntSpeedButton *SystemModelType = (TTntSpeedButton *)FindComponent("SystemModelType" + IntToStr(machineID + 1));
    if(SystemModelType)
    {
      SystemModelType->Font->Color = clBlack;

      if(machineID == tempApplicationStartOption.MachineType)
      {
        SystemModelType->Font->Color = clRed;
        SystemModelType->Down = true;
      }
    }
  }
}

//---------------------------------------------------------------------------
void __fastcall TOptionSettingForm::RefreshBoardCount()
{
  IPBBoardCountEdit->Text = IntToStr(tempApplicationStartOption.comm_brdCount);
}

//---------------------------------------------------------------------------
void __fastcall TOptionSettingForm::RefreshLaserMode()
{
  if(tempApplicationStartOption.LaserComplexer)
  {
    LaserComplexerCheckBox->Checked = true;
  }
  else
  {
    LaserComplexerCheckBox->Checked = false;
  }

  sLaserPathEdit->Text = tempApplicationStartOption.sLaserPath;
}
//---------------------------------------------------------------------------
void __fastcall TOptionSettingForm::RefreshTPBOperationMode()
{
  if(tempApplicationStartOption.TPB_OperationMode)
  {
    ckbTPB_Operation->Checked = true;
  }
  else
  {
    ckbTPB_Operation->Checked = false;
  }
}
//---------------------------------------------------------------------------
void __fastcall TOptionSettingForm::RefreshAppsTitle()
{
  tvmAppTitleEdit->Text = tempApplicationStartOption.tmsAppName;
  cvmAppTitleEdit->Text = tempApplicationStartOption.cmsAppName;
}
//---------------------------------------------------------------------------
void __fastcall TOptionSettingForm::RefreshCommCheckSW()
{
  if(tempApplicationStartOption.CommCheckSW)
  {
    ConfirmCommunicationStatusCheckBox->Checked = true;
  }
  else
  {
    ConfirmCommunicationStatusCheckBox->Checked = false;
  }
}
//---------------------------------------------------------------------------
void __fastcall TOptionSettingForm::RefreshLicenseCheckSW()
{
  if(tempApplicationStartOption.noLicenseApplication)
  {
    NoLicenseAppCheckBox->Checked = true;
  }
  else
  {
    NoLicenseAppCheckBox->Checked = false;
  }
}
//---------------------------------------------------------------------------
void __fastcall TOptionSettingForm::ActiveModeBtn1Click(TObject *Sender)
{
  TTntSpeedButton *tempSpeedBtn = (TTntSpeedButton*) Sender;
  tempApplicationStartOption.SelectedCommType = tempSpeedBtn->Tag;
  RefreshCommMode();
}
//---------------------------------------------------------------------------

void __fastcall TOptionSettingForm::SystemModelType1Click(TObject *Sender)
{
  TTntSpeedButton *tempSpeedBtn = (TTntSpeedButton*) Sender;
  tempApplicationStartOption.MachineType = tempSpeedBtn->Tag;
  RefreshMachineType();
}
//---------------------------------------------------------------------------

void __fastcall TOptionSettingForm::Image2Click(TObject *Sender)
{
  TImage *tempImage = (TImage *)Sender;

  if(tempImage->Tag == 0)
  {
    tempApplicationStartOption.SelectedLCID = 1042;
  }
  else if(tempImage->Tag == 1)
  {
    tempApplicationStartOption.SelectedLCID = 2052;
  }
  else if(tempImage->Tag == 2)
  {
    tempApplicationStartOption.SelectedLCID = 1033;
  }
  else if(tempImage->Tag == 3)
  {
    tempApplicationStartOption.SelectedLCID = 1041;
  }
  else if(tempImage->Tag == 4)
  {
    tempApplicationStartOption.SelectedLCID = 3082;
  }

  RefreshLCID();
}
//---------------------------------------------------------------------------


void __fastcall TOptionSettingForm::Button2Click(TObject *Sender)
{
  tvmAppTitleEdit->Text = "TVM_Application";
}
//---------------------------------------------------------------------------


void __fastcall TOptionSettingForm::Button4Click(TObject *Sender)
{
  cvmAppTitleEdit->Text = "CVM_Application";
}
//---------------------------------------------------------------------------

void __fastcall TOptionSettingForm::Button6Click(TObject *Sender)
{
  ModalResult = mrCancel;
}
//---------------------------------------------------------------------------


void __fastcall TOptionSettingForm::Button5Click(TObject *Sender)
{
  int brdCount;
  AnsiString TabletEnvPath  = ProgramPath.Tablet  + "\\Env\\SystemInfor.ini";
  AnsiString CapsuleEnvPath = ProgramPath.Capsule + "\\Env\\SystemInfor.ini";

  try
  {
    brdCount = StrToInt(IPBBoardCountEdit->Text);

    if(brdCount < 2 || brdCount > SYSTEM_SPB_COUNT)
    {
      throw("");
    }
  }
  catch(...)
  {
    ShowMessageFA("The input value is invalid. (Board Count)");
    return;
  }

  tempApplicationStartOption.comm_brdCount = brdCount;

  AnsiString t1, t2;
  try
  {
    t1 = tvmAppTitleEdit->Text;
    t2 = cvmAppTitleEdit->Text;

    if(t1 == "" || t2 == "")
    {
      throw("");
    }
  }
  catch(...)
  {
    ShowMessageFA("The input value is invalid. (Apps title)");
    return;
  }

  tempApplicationStartOption.tmsAppName = WideString(t1);
  tempApplicationStartOption.cmsAppName = WideString(t2);

  if(LaserComplexerCheckBox->Checked)
    tempApplicationStartOption.LaserComplexer = 1;
  else
    tempApplicationStartOption.LaserComplexer = 0;

  if(tempApplicationStartOption.LaserComplexer)
  {
    AnsiString sLaserPath;

    sLaserPath = sLaserPathEdit->Text;
    if(sLaserPath == "")
    {
      ShowMessageFA("The path is not correct. (sLaser)");
      return;
    }
    else if (!DirectoryExists(sLaserPath))
    {
      ShowMessageFA("The path is not correct. (sLaser)");
      return;
    }

    tempApplicationStartOption.sLaserPath = sLaserPath;
  }
  else
  {
    tempApplicationStartOption.sLaserPath = sLaserPathEdit->Text;
  }

  if(ConfirmCommunicationStatusCheckBox->Checked)
    tempApplicationStartOption.CommCheckSW = 1;
  else
    tempApplicationStartOption.CommCheckSW = 0;

  if(NoLicenseAppCheckBox->Checked)
  {
    tempApplicationStartOption.noLicenseApplication = 1;
  }
  else
  {
    tempApplicationStartOption.noLicenseApplication = 0;
  }

  if(ckbTPB_Operation->Checked)
  	tempApplicationStartOption.TPB_OperationMode = TPB_OPERATION;
  else
  	tempApplicationStartOption.TPB_OperationMode = TPB_NONE;

  AnsiString SystemOptionInfoFileName;
	SystemOptionInfoFileName = ProgramPath.Env_Root + "\\SystemInfo.ini";
  WriteApplicationOption(SystemOptionInfoFileName, &tempApplicationStartOption);

  if(ApplicationStartOption.MachineType == SYSTEM_INFO_MACHINE_TYPE_150T ||
     ApplicationStartOption.MachineType == SYSTEM_INFO_MACHINE_TYPE_200T)
  {
    TPB_WriteApplicationOption(TabletEnvPath, &tempApplicationStartOption);
  }
  else
  {
    TPB_WriteApplicationOption(TabletEnvPath, &tempApplicationStartOption);
    TPB_WriteApplicationOption(CapsuleEnvPath, &tempApplicationStartOption);
  }
  
  CheckChangeOption();
  
  ModalResult = mrOk;
}
//---------------------------------------------------------------------------

void __fastcall TOptionSettingForm::Panel2DblClick(TObject *Sender)
{
  LaserComplexerCheckBox->Visible = !LaserComplexerCheckBox->Visible;
  sLaserPathEdit->Visible = !sLaserPathEdit->Visible;
  FindFolderButton->Visible = !FindFolderButton->Visible;

  if(LaserComplexerCheckBox->Visible)
  {
  /*
    GroupBox2->Height = 205;
    GroupBox3->Top = 552;
    Button5->Top = 730;
    Button6->Top = 730;
    this->Height = 889;
    */
    GroupBox2->Height = 249;//169;
    GroupBox3->Top = 600;
    Button5->Top = 778;
    Button6->Top = 778;
    this->Height = 960;
  }
  else
  {
  /*
    GroupBox2->Height = 140;
    GroupBox3->Top = 480;
    Button5->Top = 658;
    Button6->Top = 658;
    this->Height = 816;
    */
    GroupBox2->Height = 169;//249;
    GroupBox3->Top = 520;
    Button5->Top = 706;
    Button6->Top = 706;
    this->Height = 880;
  }
}
//---------------------------------------------------------------------------

void __fastcall TOptionSettingForm::FindFolderButtonClick(TObject *Sender)
{
  AnsiString Dir = sLaserPathEdit->Text;
  if (SelectDirectory(Dir, TSelectDirOpts(), 0 ))
  {
    sLaserPathEdit->Text = Dir;
  }
}
//---------------------------------------------------------------------------

void __fastcall TOptionSettingForm::CheckChangeOption()
{
  if(tempApplicationStartOption.SelectedLCID != ApplicationStartOption.SelectedLCID) bChangeParams = true;
  else if(tempApplicationStartOption.SelectedCommType != ApplicationStartOption.SelectedCommType) bChangeParams = true;
  else if(tempApplicationStartOption.MachineType != ApplicationStartOption.MachineType) bChangeParams = true;
  else if(tempApplicationStartOption.comm_brdCount != ApplicationStartOption.comm_brdCount) bChangeParams = true;
  else if(tempApplicationStartOption.LaserComplexer != ApplicationStartOption.LaserComplexer) bChangeParams = true;
  else if(tempApplicationStartOption.sLaserPath != ApplicationStartOption.sLaserPath) bChangeParams = true;
  else if(tempApplicationStartOption.CommCheckSW != ApplicationStartOption.CommCheckSW) bChangeParams = true;
  else if(tempApplicationStartOption.noLicenseApplication != ApplicationStartOption.noLicenseApplication) bChangeParams = true;
  else if(tempApplicationStartOption.tmsAppName != ApplicationStartOption.tmsAppName) bChangeParams = true;
  else if(tempApplicationStartOption.cmsAppName != ApplicationStartOption.cmsAppName) bChangeParams = true;
  else if(tempApplicationStartOption.TPB_OperationMode	!= ApplicationStartOption.TPB_OperationMode) bChangeParams = true;
}
